use crate::io::byteio::*;
use super::DecoderResult;

pub mod dcl;
pub mod deflate;
pub mod imaadpcm;
pub mod jpeg;
pub mod msadpcm;
pub mod lzo;
pub mod lzs;
pub mod lzss;
pub mod path;
pub mod rnc;
pub mod yuv;

pub trait ReadVGAPal {
    fn read_vga_pal(&mut self, pal: &mut [u8; 768]) -> DecoderResult<()>;
    fn read_vga_pal_some(&mut self, pal: &mut [u8]) -> DecoderResult<()>;
}

impl<T: ?Sized + ByteIO> ReadVGAPal for T {
    fn read_vga_pal(&mut self, pal: &mut [u8; 768]) -> DecoderResult<()> {
        for el in pal.iter_mut() {
            let b = self.read_byte()?;
            *el = (b << 2) | (b >> 6);
        }
        Ok(())
    }
    fn read_vga_pal_some(&mut self, pal: &mut [u8]) -> DecoderResult<()> {
        for el in pal.iter_mut() {
            let b = self.read_byte()?;
            *el = (b << 2) | (b >> 6);
        }
        Ok(())
    }
}
