//! Structures for describing output of the input source (stream and frame information etc)

/// Audio sample format
#[derive(Clone,Copy,Debug,PartialEq)]
pub enum AudioSample {
    /// Unsigned 8-bit PCM
    U8,
    /// Signed 16-bit PCM
    S16
}

/// Audio stream information
#[derive(Clone,Copy,Debug)]
pub struct AudioInfo {
    /// Audio sample rate
    pub sample_rate:    u32,
    /// Number of channels
    pub channels:       u8,
    /// Sample type
    pub sample_type:    AudioSample,
}

/// Video stream information
#[derive(Clone,Copy,Debug)]
pub struct VideoInfo {
    /// Video width
    pub width:      usize,
    /// Video height
    pub height:     usize,
    /// Bits per pixel (8 always means paletted video)
    pub bpp:        u8,
    /// Timebase numerator
    pub tb_num:     u32,
    /// Timebase denominator
    pub tb_den:     u32,
}

/// Stream information
#[derive(Clone,Copy,Debug)]
pub enum StreamInfo {
    Audio(AudioInfo),
    Video(VideoInfo),
    None,
    Unknown,
}

/// Frame data
#[allow(clippy::large_enum_variant)]
#[derive(Clone)]
pub enum Frame {
    /// 8-bit PCM audio
    AudioU8(Vec<u8>),
    /// 16-bit PCM audio
    AudioS16(Vec<i16>),
    /// Paletted frame
    VideoPal(Vec<u8>, [u8; 768]),
    /// 15- or 16-bit RGB
    VideoRGB16(Vec<u16>),
    /// 24-bit RGB
    VideoRGB24(Vec<u8>),
}
