use std::fs::File;
use std::io::BufReader;
use crate::input::*;
use crate::io::byteio::*;
use super::{GenericEntry, GenericArchive};

pub fn open(name: &str) -> DecoderResult<Box<dyn ArchiveSource>> {
    let file = File::open(name).map_err(|_| DecoderError::InputNotFound(name.to_owned()))?;
    let mut fr = FileReader::new_read(BufReader::new(file));

    let toc_size = fr.read_u32le()? as usize;
    validate!((12..=120000).contains(&toc_size) && (toc_size % 12) == 0);
    let nfiles = toc_size / 12;

    let mut entries = Vec::with_capacity(nfiles);
    for _ in 0..nfiles {
        let fileno = fr.read_u32le()?;
        let offset = fr.read_u32le()?;
        let size = fr.read_u32le()?;
        entries.push(GenericEntry{ name: format!("{fileno:05}.bd13"), size, offset });
    }

    Ok(Box::new(GenericArchive {
        fr, entries,
        entry: 0,
    }))
}
