# na_game_tool

`na_game_tool` is a simple tool to convert obscure game (and related) formats
into raw format understandable by many tools.

## Getting Started

The project should build just fine with Rust 1.69 or later.

## Usage

The tool converts input into output (either input multimedia file into output multimedia file(s) or extracting contents of a game archive) so at least those two parameters must be provided.

`na_game_tool <infile> <outfile>` will try to detect input and output formats and convert between them.
In case when you are sure you want to extract an archive use `na_game_tool -extract <infile> <outdir>`.

For some formats this is not possible to detect the name or distinguish very similar but slightly incompatible flavours
(e.g. CRH in _Dark Earth_ and _Nightmare Creatures_ have different frame dimensions that are not stored in the file),
so input format should be provided like `na_game_tool -ifmt <format> <infile <outfile>`.

Additionally `-ofmt` can be used to set output format.
Invoke `na_game_tool --list-input-formats` or `na_game_tool --list-output-formats` in order to get the list of supported input or output formats respectively.
In case of archive extracting, output format does not make sense as output is always a directory name (which will be created if possible).

The up-to-date list of the supported input formats with the possible caveats can be found in [FORMATS.md]

### Output format plugins

There are several output formats supported by the tool:
- `avi` for AVI files. This will write an AVI file with raw video and audio streams. **Caveats:** AVIs larger than 2GB are not currently supported; also 8-bit video with palette changes may be not treated well by different tools.
- `imgseq` for image sequence. Providing an image name will make `na_game_tool` write just one image, for multiple images use a pattern e.g. `out%03d.ppm` will produce `out000.ppm`, `out001.ppm` and so on. **Note:** only PPM output is currently supported.
- `null` for null output. This may be useful for testing files.
- `wav` for outputting just audio track in RIFF Wave format.

Please note that regardless of the output format selected all data will be decoded.

### Extraction options

By default archive extractor will try to convert some of the formats into more common formats (e.g. headerless bitmaps into PNM). If this behaviour is not desired you can tell it not to do so by providing `-nocvt` switch at the end (see usage examples below).

### Some usage examples

* Converting sample to AVI while hoping that autodetection works:

`na_game_tool inputfile output.avi`

* Converting sample to AVI while claiming it is not:

`na_game_tool inputfile -ofmt avi output.wav`

or simply

`na_game_tool inputfile -f avi output.wav`

* Converting a sample from _Dark Earth_ CRH video to an image sequence:

`na_game_tool -ifmt crh-de sc03.crh -ofmt imgseq out%04d.ppm`

or simply

`na_game_tool -f crh-de sc03.crh -f imgseq out%04d.ppm`

* Extracting an archive of type `stk` into a directory named `introfiles`:

`na_game_tool -extract -ifmt stk intro.stk introfiles`

* Extracting an RLB archive without converting output:

`na_game_tool -extract -ifmt rlb demoblue.rlb demofiles -nocvt`

## Contributing

You're not supposed to. Even I hardly do that so why should you?

## License

`na_game_tool` is licensed under GNU General Public License version 3 - see [COPYING.GPL3] for details.

Parts of the project can be relicensed to other free licenses like LGPLv2 or 0BSD on request.
