# Supported Multimedia Formats

Format name | Description | Notes
----------- | ----------- | -----
`7lev_movie` | 7th Level movie | Movies stored inside `7lev_bin` archives for _Monty Python and Holy Grail_. Each movie requires three files: `.mov_toc` with metadata, `.mov_data` with frame data and `res0006` with palette data.
`ace` | Space Ace PC port scenes | Decoding is incorrect but sometimes video is recognizable
`acf` | Time Commando ACF |
`ad_mvi` | Archimedean Dynasty MVI | Or _Schleichfahrt_ MVI
`ai_cda` | Alien Incident CDA | Fading is not completely correct
`amf` | Manic Karts AMF | Also used in _City in Trouble Year 2000_
`arc-huf` | Arc Developments HUF | Used in _Johnny Bazookatone_
`ark_an` | Ark of Time animation |
`ascon` | Asc(ar)on animation format | Used at least in `Elisabeth I`/`Gloriana` game
`av_ani` | Alien Virus animation | Hacked FLI
`avenger` | Road Avenger cutscene | SEGA CD port
`avf` | American Laser Games / Her Interactive animation | Older format used in e.g. "Vampire Diaries" has an external palette stored in BMP files. So if such file is renamed to `avf-old-pal.bmp` it will be read and the palette from it will be applied to the output.
`avx` | Jack Orlando video |
`azmov` | Azrael's Tear MOV |
`b13_fli` | Bureau 13 videos | This format encapsulates pieces of FLC and raw audio
`bal` | Baldies animation | Used in older DOS version of the game (newer PC versions use FLI instead)
`bd13` | Brain Dead 13 PC port scenes | All videos are stored inside `BD.DAT`
`byon-m` | Castles 2 greyscale videos |
`c13` | Hammer of the Gods C13 | Essentially it is LZSS-compressed normal FLI
`ca2` | Microcosm CA2 |
`ccommand` | Cobra Command BIN |
`cda` | Pray for Death CDA |
`cfo` | CFO | Used in _Chewy: Esc from F5_ game. Files are stored inside `cut.tap`. Audio is not supported.
`ci2` | Arxel Tribe CI2 | Used in several of their games like _Casanova_ or _Faust_.
`cnm` | Arxel Tribe CNM | Used in _Ring: The Legend of the Nibelungen_.
`crh-de` | Dark Earth CRH |
`crh-nc` | Nightmare Creatures CRH | The format is almost the same as `crh-de` but codes 320x240 frames using a bitstream format using one extra bit in a certain place.
`cup` | Humongous Entertainment CUP | Used in various game demos
`cyclemania` | Cyclemania video | Requires several files (with `.col`, `.hed`, `.frm` and `.vid` extensions), either one of those or the base name (i.e. without extension) should be provided.
`cydonia` | Cydonia Paco | Not to be confused with PACo format used e.g. in _Iron Helix_
`defcon5` | Defcon 5 .vid | Most game versions use Smacker instead
`derf-aud` | Xilam DERF | Audio format used in _Stupid Invaders_ game
`derf-vid` | Xilam DERF | Video format used in _Stupid Invaders_ game
`dkanim` | Dorling Kindersley animation | Animation requires an accompanying `.dib` file to be decoded properly.
`dmv` | Brainstorm Technology DMV | Video format used in some trailers, games and interactive videos
`dpeg` | DPEG | The format is used in _Bloodwings: Pumpkinhead's Revenge_
`drl` | Thunder In Paradise (PC port) DRL |
`duck-uqm` | TrueMotion video used in 3DO version of _Star Control II_ | Requires several files (with `.duk`, `.hdr`, `.frm` and `.tbl` extensions), either one of those or the base name (i.e. without extension) should be provided.
`dxv` | Celestial Impact DXV |
`egg` | Independence Day EGG | Used in Saturn port of the game
`etv` | Hercules ETV |
`fcmp` | FutureVision audio format | Used in _Harvester_ game
`fla` | Little Big Adventure FLA |
`flh` | Conquest Earth FLH | Often found inside `.wad` archives
`fli` | FLIC | Includes some game-specific variations
`flk` | FLK |
`fst` | FutureVision video format | Used in _Harvester_ game
`fvf` | Spectrum Holobyte FVF | Used in such games as _Star Trek TNG - "A Final Unity"_ and _Falcon Gold_
`gav` | GTE Vantage Animation | Used in _NCAA Championship Basketball_ demo
`grn` | Microids GRN | Used in _Ultimate Domain_ / _Genesia_
`guilty` | Innocent Until Caught 1/2 cutscenes | Files are named `IUC_F??.DAT` and `GBG_F??.DAT` respectively.
`h2o` | The Pandora Directive H2O | Videos are stored unnamed inside `.ap` archives
`haf` | Death Rally HAF |
`hl-fmv` | Cutscene format from _Highlander: The Last of the MacLeods_ unpublished game |
`hnm0` | Cryo HNM version 0 | Used just of a logo in couple of floppy releases of their games
`hnm1` | Cryo HNM version 1 | Often found inside archive files. Sound is not supported.
`hnm4` | Cryo HNM version 4 | Often found inside archive files.
`hnm5` | Cryo UBB | Headerless UBB files (i.e. the ones not starting with `UBB2`) are not supported
`hnm6` | Cryo HNM version 6 | Framerate and colours may be wrong
`imv` | ICOM video |
`imx` | Fable video | This means a game from 1996 by Simbiosis Interactive
`ivas` | Tsunami Media animation | Found inside `.rlb` archives in newer Tsunami games
`ivd` | Interactive Pictures VID |
`jam` | JAM video | Used in various games
`jazz2` | Jazz Jackrabbit 2 cutscene |
`kdv-af` | Nova Logic video | Videos from _Armored Fist_
`kdv-c` | Nova Logic video | Videos from _Comanche: Maximum Overkill_
`kdv-cg` | Nova Logic video | Video from _Comanche Gold_
`kdv-wc` | Nova Logic video | Videos from _Werewolf vs. Comanche_
`kdv24` | Nova Logic video | 24-bit videos from newer games
`kingpin-bin` | The Amazing Spider-Man vs The Kingpin cutscene |
`kmvid` | Klondike Moon VID |
`koda` | Sonic CD videos | Credits rendering does not work
`lair` | Dragon's Lair PC port scenes |
`lms` | Ecco the Dolphin LMS | There is no palette present in the files, so maybe it is supposed to be grayscale.
`lotr-av` | Lord of the Rings AV |
`m95` | Interplay M95 | Used in _Cyberia 2: Resurrection_
`maelstrom-anm` | Maelstrom ANM | This means strategy game from 1992
`mfilm` | Murder FILM |
`mgif` | Gates of Skeldal MGIF |
`mh-fmv` | Machine Hunter FMV |
`mpanim` | MP Entertainment animation | FMVs used in _Hopkins FBI_
`mpanim-seq` | MP Entertainment animated sequence | FMVs used in _Hopkins FBI_ with slightly different opcodes
`mux` | MUX | Format used in various Infogrames games. _Chaos Control_ has some videos with unsupported coding mode.
`mvi1` | Ikarion MVI1 |
`mvi2` | Ikarion MVI2 |
`naf` | Ninell Animation File | Used in _Secret Service_ (1997). Single graphic files (`.ngf`) are supported as well. Actual data is gzipped first.
`ninja-bin` | Revenge of the Ninja BIN |
`nl-fmv` | Nightlong FMV | 320x180 videos used in Amiga version of the game
`nl-fmv2` | Nightlong FMV2 | 640x360 videos used in Amiga version of the game
`nxl` | The Lawnmower Man NXL |
`origin-fli` | Origin hybrid of FLI and IFF | Used in _Ultima VII_ games intro/ending. Speed changes and audio part are not supported.
`origin-sc` | Shadowcaster (CD version) cutscenes |
`origin-ssm` | System Shock movie/audio format | Videos are stored unnamed inside `.res` archives
`paco` | PACo video | Video format used e.g. in _Hell Cab_ or _Iron Helix_ (not to be confused with Cydonia Paco)
`ph` | Total Multimedia PH video | Video format used in some interactive multimedia CD-ROMs
`pmm` | Psygnosis MultiMedia | Used in games like _Area 51_ or _Maximum Force_
`pmv` | Infocom movie format used in _Return to Zork_ and some demos |
`psy-str` | Psychic Detective STR |
`ptf` | Under a Killing Moon PTF | Videos are stored unnamed inside `.ap` archives
`q` | Legend Entertainment Q | Used in various games by this company
`qrac-fmv` | Network Q RAC Rally FMV |
`rac` | Spectrum Holobyte RAC | Used in _Star Trek TNG - "A Final Unity"
`ratvid` | Ratvideo or VIDPAK | Used in several EA games
`raven-anm` | Ravenloft ANM |
`rbt` | Sierra robot format | Used in later Sierra games usually for large sprite animations
`reaper-fmv` | Reaper FMV | Used in _Rollcage_ game. Reconstruction and sound synchronisation are not working properly.
`rlf` | Sprite format used in some Zork games |
`roq` | Trilobyte / id Software RoQ |
`sdv` | Stardock video | Used in _Stardock: Entrepreneur_ multiplayer game
`sg_flc` | Packed Stargunner FLC |
`siff` | Beam Software SIFF | Used in various games by this company, often found in `.gob` archives
`sks` | Ascon SKS | Used e.g. in _Patrizier II_
`smv` | Psygnosis SMV | Used in _WipEout_ game
`soulhunt` | Soul Hunt VID | JPEG compression is not supported
`spidy-ani` | Spidy animation v2 | As used in _Imperium Galactica_. _Reunion_ format is not supported
`ssstr` | Sesame Street STR |
`talisman` | Talisman Animation | Some files are not decoded correctly
`tvi` | Terminal Velocity video | It requires global palette `vga.act` stored in `startup.pod` (but may work without it)
`um` | Dark Moon UM |
`umv-afraid` | Are You Afraid of the Dark UMV |
`umv-dracula` | Dracula Unleashed UMV | Those two formats are the same but `umv-afraid` uses signed 8-bit audio instead of unsigned.
`vdo` | Harrow Media VDO | Used in _The Fuel Run_ game
`vdx` | Trilobyte VDX | Used in _The 7th Guest_, usually stored one after another inside `.gjd` archives
`vpx1` | reLINE VPX1 | Used in _BIING!_ game
`vx` | Actimagine VX | Used in many games for a certain portable console
`warrior-anm` | Savage Warriors ANM |
`wingnuts` | Wing Nuts video frames | Since files are actually a complex engine data, only video frames are extracted.
`xanth` | Companions of Xanth cutscenes | Cutscenes are stored in files `XANTH_91.PIC`..`XANTH_99.PIC`. Other `.PIC` files from Legent Entertainment games may be extracted (best to image sequence) with some degree of success.
`yo-mxv` | Yo Matias game cutscenes and music | Newer MXV versions with Vorbis audio are not supported
`yqs` | Independence Day YQS | Used in PC port of the game
`yumimi-ablk` | Yumimi Mix animations | Only individual sprites are decoded, colours may be wrong too.
`yumimi-cut` | Yumimi Mix animations | Decoding is incomplete and timings are often wrong
`zorton` | Zorton Brothers video | PC port is also known as _Los Justicieros_

# Supported Archive Formats

Format name | Description | Notes
----------- | ----------- | -----
`7lev_bin` | 7th Level BIN | As used in _Monty Python's Complete Waste of Time_ and _Monty Python and Holy Grail_. Unknown files are not always extracted correctly. Some images may have wrong palette.
`access_ap` | Access Software AP | Used in many games starting from 1990
`b13_gl` | Bureau 13 GL |
`bd13_dat` | Brain Dead 13 DAT | DOS version
`beam_gob` | Beam Software GOB |
`ce_wad` | Conquest Earth WAD | Internal directory structure is not properly reconstructed
`cryo_archive` | Cryo Archive formats | It can be several concatenated HNM files, resource archive without a header or BigFile archive
`egg` | HotHouse EGG | Image archives used in _Who Wantes to be a Millionaire Junior Edition_
`escal-z` | Escal compressed files | Single files (usually images) compressed with a bastardisation of dynamic deflate format
`gjd` | Trilobyte GJD | Concatenated VDX files (and sometimes WAV as well) in _The 7th Guest_ game
`gk3_barn` | Gabriel Knight 3 Barn |
`goosebumps` | Goosebumps archive | Used in _Goosebumps: Escape from Horrorland_
`hell-lib` | Hell: A Cyberpunk Thriller libraries |
`horde-vdx` | The Horde video archive | Essentially it is one video split into several segments encoded as VIDPAK and assembled back into single file
`m88` | M88 Movie | Used in _Visions of Mars_
`mco` | SouthPeak Interactive puzzle library | Used in a variety of games by SPI
`mng` | Hostile Waters MNG |
`rlb` | Tsunami Media RLB |
`stk` | Coktel Vision STK |
`stk2` | Coktel Vision STK2 |
